import { jsxs, jsx } from "react/jsx-runtime";
import { D as DeleteModal } from "./delete-modal-CTUf4WRn.js";
import { I as InputError } from "./input-error-CBKwRgzN.js";
import { L as LoadingButton } from "./loading-button-C9msud_X.js";
import { A as Avatar, a as AvatarImage, b as AvatarFallback } from "./avatar-DPWl5zBC.js";
import { B as Button } from "./button-CoRGprmX.js";
import { D as DropdownMenu, a as DropdownMenuTrigger, b as DropdownMenuContent, c as DropdownMenuItem } from "./dropdown-menu-DONmDWr6.js";
import { I as Input } from "./input-BPdrsFAc.js";
import { L as Label } from "./label-BKAgVFnB.js";
import { S as Separator } from "./separator-BjFPAtSa.js";
import { o as onHandleChange } from "./inertia-BtwbgBI3.js";
import { usePage, useForm } from "@inertiajs/react";
import { format } from "date-fns";
import { EllipsisVertical, Trash, MessageCircle, SquarePen } from "lucide-react";
import { Editor, Renderer } from "richtor";
/* empty css                 */
import ForumEdit from "./forum-edit-CB59DwoH.js";
import ForumReply from "./forum-reply-DsLk-Nqn.js";
import "./dialog-Bzzm0V8u.js";
import "@radix-ui/react-dialog";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "react";
import "@radix-ui/react-avatar";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "@radix-ui/react-dropdown-menu";
import "@radix-ui/react-label";
import "@radix-ui/react-separator";
const Forum = () => {
  const { props, url } = usePage();
  const { translate } = props;
  const { button, input, frontend } = translate;
  const lesson = props.watching;
  const { data, setData, post, errors, processing, reset } = useForm({
    url,
    title: "",
    description: "",
    user_id: props.auth.user.id,
    course_id: props.course.id,
    section_lesson_id: props.watching.id
  });
  const handleSubmit = (e) => {
    e.preventDefault();
    post(route("course-forums.store"), {
      onSuccess: () => {
        reset();
      }
    });
  };
  return /* @__PURE__ */ jsxs("div", { children: [
    /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmit, className: "space-y-4 p-0.5", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx(Label, { children: input.title }),
        /* @__PURE__ */ jsx(
          Input,
          {
            required: true,
            type: "text",
            name: "title",
            value: data.title,
            placeholder: input.title_placeholder,
            onChange: (e) => onHandleChange(e, setData)
          }
        ),
        /* @__PURE__ */ jsx(InputError, { message: errors.title })
      ] }),
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx(Label, { children: input.description }),
        /* @__PURE__ */ jsx(
          Editor,
          {
            ssr: true,
            output: "html",
            placeholder: {
              paragraph: input.description,
              imageCaption: input.image_url_placeholder
            },
            contentMinHeight: 160,
            contentMaxHeight: 400,
            initialContent: data.description,
            onContentChange: (value) => setData("description", value)
          }
        ),
        /* @__PURE__ */ jsx(InputError, { message: errors.description })
      ] }),
      /* @__PURE__ */ jsx(LoadingButton, { loading: processing, children: button.submit })
    ] }),
    /* @__PURE__ */ jsx(Separator, { className: "my-6" }),
    lesson.forums.map((forum) => /* @__PURE__ */ jsxs("div", { className: "space-y-4 rounded-lg border p-6", children: [
      /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between", children: [
        /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsxs(Avatar, { className: "h-8 w-8", children: [
            /* @__PURE__ */ jsx(AvatarImage, { src: forum.user.photo || "", alt: forum.user.name, className: "object-cover" }),
            /* @__PURE__ */ jsx(AvatarFallback, { children: forum.user.name.charAt(0) })
          ] }),
          /* @__PURE__ */ jsxs("div", { children: [
            /* @__PURE__ */ jsx("p", { className: "font-semibold", children: forum.user.name }),
            /* @__PURE__ */ jsx("p", { className: "text-muted-foreground text-xs", children: format(new Date(forum.created_at), "MMM d, yyyy h:mm a") })
          ] })
        ] }),
        forum.user_id === props.auth.user.id && /* @__PURE__ */ jsxs(DropdownMenu, { children: [
          /* @__PURE__ */ jsx(DropdownMenuTrigger, { children: /* @__PURE__ */ jsx(Button, { variant: "secondary", size: "icon", className: "size-8", children: /* @__PURE__ */ jsx(EllipsisVertical, {}) }) }),
          /* @__PURE__ */ jsxs(DropdownMenuContent, { align: "end", children: [
            /* @__PURE__ */ jsx(DropdownMenuItem, { asChild: true, children: /* @__PURE__ */ jsx(ForumEdit, { url, forum }) }),
            /* @__PURE__ */ jsx(DropdownMenuItem, { asChild: true, children: /* @__PURE__ */ jsx(
              DeleteModal,
              {
                routePath: route("course-forums.destroy", forum.id),
                actionComponent: /* @__PURE__ */ jsxs(Button, { size: "sm", variant: "ghost", className: "w-full cursor-pointer justify-start px-2", children: [
                  /* @__PURE__ */ jsx(Trash, { className: "h-4 w-4" }),
                  /* @__PURE__ */ jsx("span", { children: button.delete })
                ] })
              }
            ) })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("p", { className: "text-lg font-medium", children: forum.title }),
        /* @__PURE__ */ jsx(Renderer, { value: forum.description })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between", children: [
        /* @__PURE__ */ jsx(
          ForumReply,
          {
            url,
            forum,
            user: props.auth.user,
            actionComponent: /* @__PURE__ */ jsxs(Button, { variant: "outline", size: "sm", className: "flex items-center gap-2 shadow-none", children: [
              /* @__PURE__ */ jsx(MessageCircle, { className: "h-4 w-4" }),
              /* @__PURE__ */ jsx("span", { children: button.reply })
            ] })
          }
        ),
        /* @__PURE__ */ jsxs("p", { className: "text-muted-foreground text-xs", children: [
          forum.replies.length,
          " ",
          frontend.replies
        ] })
      ] }),
      /* @__PURE__ */ jsx(Separator, { className: "my-6" }),
      /* @__PURE__ */ jsx("div", { className: "space-y-8 pl-6", children: forum.replies.map((reply) => /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
        /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-between", children: [
          /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
            /* @__PURE__ */ jsxs(Avatar, { className: "h-8 w-8", children: [
              /* @__PURE__ */ jsx(AvatarImage, { src: reply.user.photo || "", alt: reply.user.name, className: "object-cover" }),
              /* @__PURE__ */ jsx(AvatarFallback, { children: reply.user.name.charAt(0) })
            ] }),
            /* @__PURE__ */ jsxs("div", { children: [
              /* @__PURE__ */ jsx("p", { className: "font-semibold", children: reply.user.name }),
              /* @__PURE__ */ jsx("p", { className: "text-muted-foreground text-xs", children: format(new Date(reply.created_at), "MMM d, yyyy h:mm a") })
            ] })
          ] }),
          reply.user_id === props.auth.user.id && /* @__PURE__ */ jsxs(DropdownMenu, { children: [
            /* @__PURE__ */ jsx(DropdownMenuTrigger, { children: /* @__PURE__ */ jsx(Button, { variant: "secondary", size: "icon", className: "size-8", children: /* @__PURE__ */ jsx(EllipsisVertical, {}) }) }),
            /* @__PURE__ */ jsxs(DropdownMenuContent, { align: "end", children: [
              /* @__PURE__ */ jsx(DropdownMenuItem, { asChild: true, children: /* @__PURE__ */ jsx(
                ForumReply,
                {
                  url,
                  forum,
                  reply,
                  user: props.auth.user,
                  actionComponent: /* @__PURE__ */ jsxs(Button, { size: "sm", variant: "ghost", className: "w-full cursor-pointer justify-start px-2", children: [
                    /* @__PURE__ */ jsx(SquarePen, { className: "h-4 w-4" }),
                    /* @__PURE__ */ jsx("span", { children: button.edit })
                  ] })
                }
              ) }),
              /* @__PURE__ */ jsx(DropdownMenuItem, { asChild: true, children: /* @__PURE__ */ jsx(
                DeleteModal,
                {
                  routePath: route("course-forum-replies.destroy", reply.id),
                  actionComponent: /* @__PURE__ */ jsxs(Button, { size: "sm", variant: "ghost", className: "w-full cursor-pointer justify-start px-2", children: [
                    /* @__PURE__ */ jsx(Trash, { className: "h-4 w-4" }),
                    /* @__PURE__ */ jsx("span", { children: "Delete" })
                  ] })
                }
              ) })
            ] })
          ] })
        ] }),
        /* @__PURE__ */ jsx(Renderer, { value: reply.description })
      ] }, reply.id)) })
    ] }, forum.id))
  ] });
};
export {
  Forum as default
};
